<?php
declare(strict_types=1);

/* ================== CORS & Headers ================== */
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

/* ============== SECURITY (must match JS) ============== */
$EXPECTED_API_KEY = 'TVP_SECRET_123';

/* ============== DB CONFIG (Namecheap) ============== */
$DB_HOST = 'localhost';
$DB_NAME = 'tvnuzqfp_LoginPluxi';
$DB_USER = 'tvnuzqfp_YoussefDataLogin';
$DB_PASS = 'N67M5aLYQHM}';

/* ============== Helpers ============== */
function jexit(array $obj, int $code = 200): void {
  http_response_code($code);
  echo json_encode($obj);
  exit;
}
function get_input(): array {
  $raw = file_get_contents('php://input') ?: '';
  $in  = json_decode($raw, true);
  if (!is_array($in)) $in = $_POST ?: [];
  return $in;
}
function domain_from_env(): ?string {
  $origin  = $_SERVER['HTTP_ORIGIN']  ?? '';
  $referer = $_SERVER['HTTP_REFERER'] ?? '';
  $host = parse_url($origin ?: $referer, PHP_URL_HOST);
  if (!$host) return null;
  return strtolower($host);
}

/* ============== PDO (with schema ensures) ============== */
try {
  $pdo = new PDO(
    "mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4",
    $DB_USER, $DB_PASS,
    [
      PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES   => false,
    ]
  );
} catch (Throwable $e) {
  jexit(['ok'=>false,'error'=>'db_connect_failed'], 500);
}

/* Create main table if missing (includes `site`) */
$pdo->exec("
CREATE TABLE IF NOT EXISTS chat_messages (
  id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  chat_id      VARCHAR(64)  NOT NULL,
  role         ENUM('user','bot') NOT NULL,
  message      TEXT NOT NULL,
  route        VARCHAR(64)  DEFAULT 'general',
  site         VARCHAR(120) DEFAULT NULL,
  ip           VARCHAR(45)  DEFAULT NULL,
  user_agent   VARCHAR(255) DEFAULT NULL,
  created_at   TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  INDEX idx_chat_id (chat_id),
  INDEX idx_created (created_at),
  INDEX idx_site (site)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci
");

/* Backfill: add `site` if table existed without it */
try {
  $col = $pdo->query("SHOW COLUMNS FROM chat_messages LIKE 'site'")->fetch();
  if (!$col) {
    $pdo->exec("ALTER TABLE chat_messages ADD COLUMN site VARCHAR(120) NULL AFTER route");
    $pdo->exec("CREATE INDEX idx_site ON chat_messages(site)");
  }
} catch (Throwable $e) { /* ignore if no ALTER rights */ }

/* Lightweight settings table for mute state (optional but used by bot_state) */
$pdo->exec("
CREATE TABLE IF NOT EXISTS chat_settings(
  chat_id VARCHAR(64) PRIMARY KEY,
  bot_muted TINYINT(1) NOT NULL DEFAULT 0,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
");

/* ================== ROUTING: GET actions ==================
   - ?action=pull&chatId=...&sinceId=...
   - ?action=bot_state&chatId=...
   NOTE: These endpoints do NOT require apiKey (public read used by widget).
============================================================ */
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
  $action = $_GET['action'] ?? '';

  if ($action === 'pull') {
    $chatId  = trim((string)($_GET['chatId'] ?? ''));
    $sinceId = (int)($_GET['sinceId'] ?? 0);
    if ($chatId === '') jexit(['ok'=>false,'error'=>'missing_chatId'], 400);

    $stmt = $pdo->prepare("
      SELECT id, chat_id, role, message, route, site, ip, user_agent, created_at
      FROM chat_messages
      WHERE chat_id = :chatId AND id > :sinceId
      ORDER BY id ASC
      LIMIT 200
    ");
    $stmt->execute([':chatId'=>$chatId, ':sinceId'=>$sinceId]);
    $items = $stmt->fetchAll();
    jexit(['ok'=>true, 'items'=>$items]);
  }

  if ($action === 'bot_state') {
    $chatId = trim((string)($_GET['chatId'] ?? ''));
    if ($chatId === '') jexit(['ok'=>false,'error'=>'missing_chatId'], 400);
    $s = $pdo->prepare("SELECT bot_muted FROM chat_settings WHERE chat_id=?");
    $s->execute([$chatId]);
    $muted = (int)($s->fetch()['bot_muted'] ?? 0);
    jexit(['ok'=>true, 'muted'=>($muted ? true : false)]);
  }

  // Unknown GET action
  jexit(['ok'=>false,'error'=>'unknown_action'], 400);
}

/* ================== POST: create message ================== */
$in = get_input();

$apiKey  = (string)($in['apiKey']  ?? '');
$chatId  = trim((string)($in['chatId']  ?? ''));
$route   = trim((string)($in['route']   ?? 'general'));
$role    = trim((string)($in['role']    ?? 'user'));   // 'user' or 'bot'
$message = trim((string)($in['message'] ?? ''));
$site    = trim((string)($in['site']    ?? ''));       // NEW: website/domain (optional)

if ($apiKey !== $EXPECTED_API_KEY) {
  jexit(['ok'=>false,'error'=>'bad_api_key'], 401);
}
if ($chatId === '' || $message === '' || !in_array($role, ['user','bot'], true)) {
  jexit(['ok'=>false,'error'=>'missing_fields','need'=>['chatId','role(user|bot)','message']], 400);
}

/* Cap size to protect DB */
if (mb_strlen($message, 'UTF-8') > 8000) {
  $message = mb_substr($message, 0, 8000, 'UTF-8');
}

/* Site fallback from ORIGIN / REFERER */
if ($site === '') {
  $auto = domain_from_env();
  if ($auto) $site = $auto;
}

/* Insert row */
$ip = $_SERVER['REMOTE_ADDR'] ?? null;
$ua = substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255);

$stmt = $pdo->prepare("
  INSERT INTO chat_messages (chat_id, role, message, route, site, ip, user_agent)
  VALUES (:chat_id, :role, :message, :route, :site, :ip, :ua)
");
$stmt->execute([
  ':chat_id' => $chatId,
  ':role'    => $role,
  ':message' => $message,
  ':route'   => $route,
  ':site'    => ($site !== '' ? $site : null),
  ':ip'      => $ip,
  ':ua'      => $ua,
]);

jexit(['ok'=>true, 'id'=>$pdo->lastInsertId()]);
