(function () {
  /* ---------- CONFIG (merge window.TVPChatConfig) ---------- */
  const DEF = {
    webhook: { url: "", route: "general" },
    theme:   { from:"#3B82F6", to:"#7C3AED" },
    mobile:  { widthPct: 0.92, heightPct: 0.70, minW: 300, maxW: 420, minH: 380, maxH: 640 },
    logging: { url: "./save_message.php", apiKey: "TVP_SECRET_123" },

    sound: { enabled:true, volume:0.4, src:"data:audio/mp3;base64,//uQxAAAA..." },
    proactive: {
      enabled:true, delayMs:25000, minScrollPx:300,
      text:"Besoin d’un coup de main ? Je peux vous guider 🙂",
      onlyOncePerSession:true
    },

    // WhatsApp button — new presets: icon | chip | ghost
    whatsapp: {
      enabled: true,
      number: "",                 // e.g. "212612345678" (no +, spaces)
      prefill: "Bonjour ! J’ai une question à propos de TVPLUXI.",
      style: "icon",              // "icon" | "chip" | "ghost"
      size: 36,                   // px (only for icon style)
      color: "#22c55e",           // icon/chip background
      textColor: "#ffffff",       // chip/ghost text color
      label: "WhatsApp"           // used in chip/ghost
    }
  };
  const deepMerge = (a,b)=>{const o=JSON.parse(JSON.stringify(a));(function m(x,y){for(const k in y){if(y[k]&&typeof y[k]==="object"&&!Array.isArray(y[k])){x[k]=x[k]||{};m(x[k],y[k]);}else{x[k]=y[k];}}})(o,b||{});return o;};
  const CFG = deepMerge(DEF,(typeof window!=="undefined"&&window.TVPChatConfig)?window.TVPChatConfig:{});

  /* ---------- SHADOW DOM ---------- */
  if (document.getElementById("tvp-host")) return;
  const host=document.createElement("div"); host.id="tvp-host"; document.body.appendChild(host);
  const shadow=host.attachShadow({mode:"open"});

  const font=document.createElement("link");
  font.rel="stylesheet";
  font.href="https://cdnjs.cloudflare.com/ajax/libs/geist-font/1.0.0/fonts/geist-sans/style.min.css";
  shadow.appendChild(font);

  /* ---------- HTML ---------- */
  const root=document.createElement("div"); root.id="tvp-root";
  root.innerHTML = `
    <button id="tvp-fab" aria-label="Open chat" title="Open chat">💬</button>
    <div id="tvp-chat" role="dialog" aria-label="Chat TVPremiumPro">
      <div class="tvp__header">
        <div class="tvp__brand">
          <div class="logo">TP</div>
          <div class="ttl">Support TVPremiumPro</div>
        </div>
        <div class="tvp__actions">
          <a id="tvp-wa" class="wa is-hidden" href="#" target="_blank" rel="noopener noreferrer" title="WhatsApp">
            <!-- SVG icon always present; label shown per style -->
            <span class="wa-ico" aria-hidden="true">
              <svg viewBox="0 0 24 24" width="100%" height="100%" focusable="false" aria-hidden="true">
                <path fill="currentColor" d="M12.04 2a9.9 9.9 0 0 0-8.47 15.04L2 22l5.08-1.54A9.95 9.95 0 1 0 12.04 2Zm5.82 14.22c-.24.68-1.39 1.29-1.94 1.33-.52.04-1.18.06-1.9-.12-.44-.11-1-.32-1.73-.63-3.05-1.31-5.03-4.36-5.18-4.56-.15-.2-1.24-1.65-1.24-3.16s.78-2.25 1.06-2.56c.28-.31.62-.39.83-.39h.6c.19 0 .45-.07.69.53.24.6.83 2.07.9 2.22.07.15.11.33.02.53-.09.2-.14.33-.28.5-.14.17-.29.38-.42.51-.14.14-.28.3-.12.58.15.28.67 1.1 1.44 1.79 1 0.9 1.85 1.18 2.14 1.32.28.14.45.12.62-.07.17-.19.72-.84.91-1.12.19-.28.38-.23.64-.14.26.09 1.64.77 1.92.91.28.14.46.21.53.33.07.12.07.7-.17 1.38Z"/>
              </svg>
            </span>
            <span class="wa-txt"></span>
          </a>
          <button class="tvp__close" id="tvp-close" aria-label="Close" title="Close">&times;</button>
        </div>
      </div>
      <div class="tvp__body">
        <div class="msgs" id="tvp-msgs">
          <div class="msg msg--bot">Bonjour 👋, comment pouvons-nous vous aider&nbsp;?</div>
        </div>
      </div>
      <div class="tvp__footer">
        <input id="tvp-input" type="text" placeholder="Écrivez votre message… (Entrée pour envoyer)"/>
        <button id="tvp-send">Envoyer</button>
      </div>
    </div>
  `;
  shadow.appendChild(root);

  /* ---------- STYLES ---------- */
  const style=document.createElement("style");
  style.textContent = `
    :host, #tvp-root{font-family:'Geist Sans',system-ui,-apple-system,Segoe UI,Roboto,Inter,Arial,sans-serif}
    *,*::before,*::after{box-sizing:border-box}

    #tvp-fab{
      position:fixed; right:var(--fab-r,18px); bottom:var(--fab-b,18px); z-index:2147483647;
      width:var(--fab-w,58px); height:var(--fab-h,58px); border-radius:50%; border:0; cursor:pointer;
      color:#fff; font-size:var(--fab-fs,22px); font-weight:700; display:grid; place-items:center;
      background:linear-gradient(135deg, var(--brand-from), var(--brand-to));
      box-shadow:0 14px 48px rgba(0,0,0,.22);
    }

    #tvp-chat{
      position:fixed; right:var(--chat-r,18px); bottom:var(--chat-b,18px); z-index:2147483646;
      width:var(--chat-w,390px); height:var(--chat-h,600px);
      max-width:calc(100vw - 24px); max-height:calc(100vh - 24px);
      display:none; flex-direction:column; overflow:hidden;
      background:#fff; border:1px solid #e7e9f2; border-radius:var(--chat-radius,20px);
      box-shadow:0 14px 48px rgba(0,0,0,.22);
      padding-bottom:env(safe-area-inset-bottom);
    }

    .tvp__header{
      display:flex; align-items:center; justify-content:space-between; gap:8px;
      padding:14px 16px; color:#fff;
      background:linear-gradient(135deg, var(--brand-from), var(--brand-to));
    }
    .tvp__brand{ display:flex; align-items:center; gap:10px; font-weight:800; min-width:0 }
    .logo{
      width:36px; height:36px; border-radius:10px; display:grid; place-items:center; font-weight:900;
      background:#ffffff22; border:1px solid #ffffff40; flex:0 0 auto;
    }
    .ttl{ white-space:nowrap; overflow:hidden; text-overflow:ellipsis; }

    .tvp__actions{ display:flex; align-items:center; gap:8px; }

    /* Close */
    .tvp__close{
      width:36px; height:36px; border-radius:10px; display:grid; place-items:center; flex:0 0 auto;
      border:1px solid #ffffff40; background:#ffffff22; color:#fff; cursor:pointer; font-size:18px; line-height:0;
    }

    /* WhatsApp presets */
    .wa{ text-decoration:none; display:inline-flex; align-items:center; gap:8px; }
    .wa-ico{ display:inline-grid; place-items:center; color:currentColor }
    .wa-txt{ font-weight:800 }

    /* icon: circular minimal */
    .wa--icon{
      --wa-size: 36px;
      width:var(--wa-size); height:var(--wa-size);
      border-radius:50%; background:var(--wa-bg,#22c55e); color:var(--wa-ink,#fff);
      border:1px solid #ffffff40; box-shadow:0 6px 16px rgba(0,0,0,.18);
      justify-content:center; overflow:hidden;
    }
    .wa--icon .wa-ico{ width:60%; height:60%; }
    .wa--icon .wa-txt{ display:none }

    /* chip: rounded pill */
    .wa--chip{
      padding:8px 10px; border-radius:999px;
      background:var(--wa-bg,#22c55e); color:var(--wa-ink,#fff);
      border:1px solid #ffffff40; box-shadow:0 4px 10px rgba(0,0,0,.12);
      font-size:13px;
    }
    .wa--chip .wa-ico{ width:16px; height:16px }
    .wa--chip .wa-txt{ max-width:120px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; }
    @media (max-width:420px){ .wa--chip .wa-txt{ display:none } }

    /* ghost: text link */
    .wa--ghost{
      padding:6px 8px; border-radius:10px;
      color:var(--wa-ink,#eaffef); border:1px solid #ffffff40; background:#ffffff22;
      font-weight:800; font-size:13px;
    }
    .wa--ghost .wa-ico{ width:14px; height:14px }

    .tvp__body{ flex:1; overflow:auto; padding:16px 12px; background:linear-gradient(180deg,#fff 0%,#f9faff 100%); }
    .msgs{ display:flex; flex-direction:column; gap:10px; }
    .msg{ max-width:82%; padding:12px 14px; border-radius:14px; font-size:14px; line-height:1.45;
          word-wrap:break-word; white-space:pre-wrap; box-shadow:0 2px 8px rgba(0,0,0,.06); }
    .msg--user{ align-self:flex-end; color:#111827; background:#eef2ff; border:1px solid #dbe2ff; border-bottom-right-radius:6px; }
    .msg--bot{ align-self:flex-start; color:#fff; background:linear-gradient(135deg, var(--brand-from), var(--brand-to)); border-bottom-left-radius:6px; }

    .typing{ align-self:flex-start; background:#f0eaff; color:#5b21b6; border:1px dashed #d8c8ff; }
    .dots{ display:inline-flex; gap:4px; margin-left:6px; vertical-align:middle; }
    .dot{ width:6px; height:6px; border-radius:50%; background:#5b21b6; opacity:.5; animation:tvp-blink 1.2s infinite; }
    .dot:nth-child(2){animation-delay:.2s}.dot:nth-child(3){animation-delay:.4s}
    @keyframes tvp-blink{0%,60%,100%{opacity:.25}30%{opacity:1}}

    .tvp__footer{ padding:10px; display:flex; gap:8px; align-items:center; background:#fff; border-top:1px solid #e7e9f2; }
    #tvp-input{
      flex:1; height:var(--inp-h,42px); border-radius:12px; border:1px solid #e7e9f2; padding:0 12px; outline:none;
      background:#f6f7fb; font-size:16px; -webkit-text-size-adjust:100%;
    }
    #tvp-send{
      height:var(--btn-h,42px); min-width:92px; border-radius:12px; border:0; cursor:pointer; color:#fff; font-weight:700;
      background:linear-gradient(135deg, var(--brand-from), var(--brand-to)); font-size:16px;
    }
    #tvp-send:disabled{ opacity:.6; cursor:not-allowed; }
    @media (max-width:559px){ .tvp__header{ padding:12px 14px } .msg{ font-size:13.5px } }

    .is-hidden{ display:none !important }
  `;
  shadow.appendChild(style);

  /* ---------- SIZE VARS ---------- */
  const rootEl=root; const setVar=(n,v)=>rootEl.style.setProperty(n,v);
  setVar("--brand-from", CFG.theme.from);
  setVar("--brand-to",   CFG.theme.to);

  function computeSize(opts={keyboard:false}){
    const w=Math.min(window.innerWidth||0, screen.width||Infinity);
    const h=window.innerHeight||document.documentElement.clientHeight||screen.height||0;
    const isDesktop=w>=560;
    let panelW=isDesktop?390:Math.round(Math.max(CFG.mobile.minW,Math.min(CFG.mobile.maxW,w*CFG.mobile.widthPct)));
    let panelH=isDesktop?600:Math.round(Math.max(CFG.mobile.minH,Math.min(CFG.mobile.maxH,h*CFG.mobile.heightPct)));
    if(!isDesktop&&opts.keyboard) panelH=Math.round(Math.max(CFG.mobile.minH,Math.min(CFG.mobile.maxH,h*0.58)));
    const fabSize=isDesktop?58:52; const radius=isDesktop?20:16;
    setVar("--chat-w",panelW+"px"); setVar("--chat-h",panelH+"px");
    setVar("--chat-r",(isDesktop?18:12)+"px"); setVar("--chat-b",(isDesktop?18:12)+"px");
    setVar("--chat-radius",radius+"px");
    setVar("--fab-w",fabSize+"px"); setVar("--fab-h",fabSize+"px");
    setVar("--fab-fs",(isDesktop?22:20)+"px"); setVar("--fab-r",(isDesktop?18:12)+"px"); setVar("--fab-b",(isDesktop?18:12)+"px");
    setVar("--inp-h",(isDesktop?42:40)+"px"); setVar("--btn-h",(isDesktop?42:40)+"px");
  }
  computeSize();
  let resizeTimer=null;
  const onResize=()=>{ clearTimeout(resizeTimer); resizeTimer=setTimeout(()=>computeSize({keyboard:false}),80); };
  window.addEventListener("resize", onResize);
  window.addEventListener("orientationchange", ()=>setTimeout(()=>computeSize({keyboard:false}),120));

  /* ---------- HELPERS ---------- */
  const $=(sel)=>shadow.querySelector(sel);
  const msgs=$("#tvp-msgs"), chat=$("#tvp-chat"), fab=$("#tvp-fab"), closeBtn=$("#tvp-close");
  const input=$("#tvp-input"), sendBtn=$("#tvp-send");
  const waBtn=$("#tvp-wa"), waTxt=$("#tvp-wa")?.querySelector(".wa-txt"), waIco=$("#tvp-wa")?.querySelector(".wa-ico");

  function scrollBottom(){ const body=shadow.querySelector(".tvp__body"); body.scrollTop=body.scrollHeight; }
  function getChatId(){
    try{ let id=localStorage.getItem("tvp_chat_id");
      if(!id){ id="chat_"+Math.random().toString(36).slice(2,11); localStorage.setItem("tvp_chat_id",id); }
      return id;
    }catch(_){ return "chat_"+Math.random().toString(36).slice(2,11); }
  }

  // SOUND
  let audioEl=null;
  function ensureAudio(){
    if(audioEl||!CFG.sound||!CFG.sound.enabled) return;
    audioEl=document.createElement("audio"); audioEl.preload="auto";
    try{ audioEl.volume=Math.max(0,Math.min(1,CFG.sound.volume??0.4)); }catch(_){}
    audioEl.src=CFG.sound.src;
    document.addEventListener("click",()=>{audioEl.play().then(()=>{audioEl.pause();audioEl.currentTime=0;}).catch(()=>{});},{once:true,capture:true});
  }
  function ding(){ if(!audioEl||!CFG.sound||!CFG.sound.enabled) return; try{ audioEl.currentTime=0; audioEl.play().catch(()=>{});}catch(_){} }

  function addUserBubble(text){ const b=document.createElement("div"); b.className="msg msg--user"; b.textContent=String(text); msgs.appendChild(b); scrollBottom(); }
  function addTyping(){ const t=document.createElement("div"); t.className="msg typing"; t.innerHTML=`Rédaction<span class="dots"><span class="dot"></span><span class="dot"></span><span class="dot"></span></span>`; msgs.appendChild(t); scrollBottom(); return t; }
  async function addBotBubbleTypewriter(text){
    const b=document.createElement("div"); b.className="msg msg--bot"; msgs.appendChild(b); scrollBottom();
    const chars=Array.from(String(text));
    for(let i=0;i<chars.length;i++){ b.textContent+=chars[i]; if(i%2===0) await new Promise(r=>setTimeout(r,12)); scrollBottom(); }
    ding();
  }

  /* ---------- PULL NEW (admin/bot messages) ---------- */
  let LAST_ID=0, POLL=null, PRIMED=false;
  function buildPullURL(sinceId){
    const base=CFG.logging&&CFG.logging.url?CFG.logging.url:""; if(!base) return null;
    const u=new URL(base,location.href);
    u.searchParams.set("action","pull"); u.searchParams.set("chatId",getChatId()); u.searchParams.set("sinceId",String(sinceId||0));
    return u.toString();
  }
  async function primeLastId(){
    if(PRIMED) return; const url=buildPullURL(0); if(!url) return;
    try{ const r=await fetch(url); const d=await r.json().catch(()=>({})); const items=Array.isArray(d.items)?d.items:[];
      if(items.length) LAST_ID=Number(items[items.length-1].id)||0;
    }catch(_){}
    PRIMED=true;
  }
  async function pullNew(){
    const url=buildPullURL(LAST_ID); if(!url) return;
    try{ const r=await fetch(url); const d=await r.json().catch(()=>({})); const items=Array.isArray(d.items)?d.items:[];
      for(const m of items){ LAST_ID=Math.max(LAST_ID,Number(m.id)||0); if(m.role==="bot"){ await addBotBubbleTypewriter(String(m.message??"")); } }
    }catch(_){}
  }

  /* ---------- LOGGING ---------- */
  async function tvpLog(role,text){
    if(!CFG.logging||!CFG.logging.url||!CFG.logging.apiKey) return;
    try{
      const res=await fetch(CFG.logging.url,{method:"POST",headers:{"Content-Type":"application/json"},
        body:JSON.stringify({apiKey:CFG.logging.apiKey, chatId:getChatId(), route:CFG.webhook.route||"general", role, message:String(text||"")})});
      const j=await res.json().catch(()=>({})); if(j&&j.id) LAST_ID=Math.max(LAST_ID,Number(j.id)||0);
    }catch(e){ console.warn("tvpLog failed",e); }
  }

  /* ---------- BOT MUTE CHECK ---------- */
  async function isBotMuted(){
    if(!CFG.logging||!CFG.logging.url) return false;
    try{
      const u=new URL(CFG.logging.url,location.href);
      u.searchParams.set("action","bot_state"); u.searchParams.set("chatId",getChatId());
      const r=await fetch(u.toString()); const j=await r.json(); return j&&j.muted===true;
    }catch(_){ return false; }
  }

  /* ---------- PROACTIVE ---------- */
  (function setupProactive(){
    if(!CFG.proactive||!CFG.proactive.enabled) return;
    const KEY="tvp_proactive_done"; if(CFG.proactive.onlyOncePerSession&&sessionStorage.getItem(KEY)) return;
    let scrolledEnough=false, timerFired=false;
    function maybeSend(){
      if(timerFired&&scrolledEnough){
        const hasUserMsg=!!shadow.querySelector(".msg.msg--user");
        if(!hasUserMsg){ addBotBubbleTypewriter(CFG.proactive.text); tvpLog("bot",CFG.proactive.text); }
        sessionStorage.setItem(KEY,"1");
        window.removeEventListener("scroll",onScroll,true);
      }
    }
    function onScroll(){ const y=window.scrollY||document.documentElement.scrollTop||0; if(y>=(CFG.proactive.minScrollPx||300)){ scrolledEnough=true; maybeSend(); } }
    window.addEventListener("scroll",onScroll,true);
    setTimeout(()=>{ timerFired=true; maybeSend(); }, Math.max(0,CFG.proactive.delayMs||25000));
  })();

  /* ---------- WHATSAPP SETUP ---------- */
  function setupWhatsApp(){
    if(!waBtn) return;
    const W=CFG.whatsapp||{}; const number=(W.number||"").replace(/[^\d]/g,"");
    if(!W.enabled||!number){ waBtn.classList.add("is-hidden"); return; }

    // set style class & vars
    waBtn.classList.remove("is-hidden","wa--icon","wa--chip","wa--ghost");
    const stylePreset=(W.style||"icon").toLowerCase();
    waBtn.classList.add(stylePreset==="chip"?"wa--chip":stylePreset==="ghost"?"wa--ghost":"wa--icon");
    waBtn.style.setProperty("--wa-bg", W.color||"#22c55e");
    waBtn.style.setProperty("--wa-ink", W.textColor||"#ffffff");
    if(stylePreset==="icon"){
      waBtn.style.setProperty("--wa-size", (W.size||36)+"px");
      if(waIco){ waIco.style.width=""; waIco.style.height=""; }
    }
    if(waTxt){ waTxt.textContent = (stylePreset==="chip"||stylePreset==="ghost") ? (W.label||"WhatsApp") : ""; }

    const buildHref=()=>`https://wa.me/${number}?text=${encodeURIComponent((W.prefill||"Bonjour!")+" (chat "+getChatId()+")")}`;
    waBtn.href=buildHref();
    waBtn.addEventListener("click", ()=>{ waBtn.href=buildHref(); }, {capture:true});
  }

  /* ---------- UI BEHAVIOR ---------- */
  fab.addEventListener("click", async ()=>{
    chat.style.display="flex"; fab.style.display="none"; input.focus(); computeSize({keyboard:false});
    input.setAttribute("placeholder","Écrivez votre message… (Entrée pour envoyer)");

    ensureAudio();
    setupWhatsApp();

    if(!POLL){ await primeLastId(); await pullNew(); POLL=setInterval(pullNew,4000); }
  });
  closeBtn.addEventListener("click", ()=>{ chat.style.display="none"; fab.style.display="grid"; });

  input.addEventListener("focus", ()=>computeSize({keyboard:true}));
  input.addEventListener("blur", ()=>setTimeout(()=>computeSize({keyboard:false}),50));
  input.addEventListener("keydown",(e)=>{ if(e.key==="Enter"&&!e.shiftKey){ e.preventDefault(); sendBtn.click(); } });

  sendBtn.addEventListener("click", async ()=>{
    const message=(input.value||"").trim(); if(!message||sendBtn.disabled) return;
    addUserBubble(message); input.value=""; input.focus(); const typing=addTyping(); sendBtn.disabled=true;
    tvpLog("user",message);
    try{
      const muted=await isBotMuted(); if(muted){ typing.remove(); return; }
      const target=CFG.webhook&&CFG.webhook.url?CFG.webhook.url:""; if(!target) throw new Error("Missing CFG.webhook.url");
      const res=await fetch(target,{method:"POST",headers:{"Content-Type":"application/json"},
        body:JSON.stringify({chatId:getChatId(),message,route:CFG.webhook.route})});
      let data={}; try{ data=await res.json(); }catch(_){}
      typing.remove();
      const reply=data?.output ?? data?.text ?? data?.data ?? "Désolé, je n’ai pas compris.";
      await addBotBubbleTypewriter(reply); tvpLog("bot",reply);
    }catch(err){
      typing.remove(); const fail="Erreur réseau. Réessayez."; await addBotBubbleTypewriter(fail); tvpLog("bot",fail); console.error(err);
    }finally{ sendBtn.disabled=false; scrollBottom(); }
  });

  /* ---------- BRAND VARS ---------- */
  root.style.setProperty("--brand-from", CFG.theme.from);
  root.style.setProperty("--brand-to",   CFG.theme.to);
})();
