<?php
// go.php on tvpluxi

const LINK_SECRET   = 'b8c6e2c1d1a04b1e7e3a2b9f6c0d4a8894a1b3c7d5e2f9a0b7c6d5e4a3b2c1d0';

// this will be built per-offer below, so leave empty here
const CHECKOUT_URL  = '';
// you already have this file:
const REDIRECT_PAGE = 'https://raidlinestudio.com/redirect2.html?redirect=';

$code = $_GET['code'] ?? '';
if (!$code) {
    http_response_code(400);
    exit('missing code');
}

// we expect the offer in URL too, like ?code=OFFER_9
$offer = $_GET['offer'] ?? '';
if (!$offer) {
    http_response_code(400);
    exit('missing offer');
}

// each offer goes to a different checkout (raidline.com or railline.store)
$offers = [
    // offer_code  => checkout_base
    'OFFER_9'   => 'https://tapraidgame.store/cart/45893501092005:1',
    'OFFER_199'  => 'https://tapraidgame.store/cart/45862150045861:1',
    'OFFER_59'  => 'https://tapraidgame.store/cart/45862127763621:1',
    'OFFER_49'  => 'https://tapraidgame.store/cart/45862127730853:1',
    'OFFER_79'  => 'https://tapraidgame.store/cart/45862127796389:1',
];

if (!isset($offers[$offer])) {
    http_response_code(404);
    exit('unknown offer');
}

$checkoutBase = $offers[$offer];

// TTL can be passed, if not we use 15 minutes
$ttl  = max(60, (int)($_GET['ttl'] ?? 900));
$t    = time();

// payload same as your example
$payload = $code.'|'.$t.'|'.$ttl;
$sig     = hash_hmac('sha256', $payload, LINK_SECRET);

// final target: your real checkout page with signed params
$target = $checkoutBase
    .'?c='.rawurlencode($code)
    .'&t='.$t
    .'&ttl='.$ttl
    .'&s='.$sig;

// then send user to your redirect2.html which will do window.location=...
$final  = REDIRECT_PAGE . rawurlencode($target);

header('Location: '.$final, true, 302);
exit;
